﻿namespace Code6587EN.Ch04.ActivateBrandingFeature
{
    using Microsoft.SharePoint;
    using Microsoft.SharePoint.Administration;
    using System;

    /// <summary>
    /// Console Application to apply the Custom Branding Feature to all Site Collections
    /// </summary>
    class Program
    {
        private static readonly Guid FeatureBrandingSiteCollectionId = new Guid("19e46226-efb9-4761-b09a-cb8711fd503a");

        static void Main(string[] args)
        {
            // Iterate through each content Web Application on the farm
            foreach (SPWebApplication webApp in SPWebService.ContentService.WebApplications)
            {
                // Iterate through each Site Collection in the Web Application
                foreach (SPSite site in webApp.Sites)
                {
                    // Ensure the Site Collection is in 2013 mode
                    if (site.CompatibilityLevel == 15)
                    {
                        // If the feature is not activated, activate it
                        if (site.Features[FeatureBrandingSiteCollectionId] == null)
                            site.Features.Add(FeatureBrandingSiteCollectionId);
                    }

                    // Dispose the Site Collection object
                    site.Dispose();
                }
            }

            // Wait for a key to be pressed before closing the application
            Console.WriteLine("Press Any Key to Continue...");
            Console.Read();
        }
    }
}
